using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents get user demographics request 
	/// message defined in VistALink protocol. 
	/// </summary>
	public sealed class SecurityGetUserDemographicsRequestMessage : SecuritySimpleRequestMessage
	{
		/// <summary>
		/// VistALink message request type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string RequestType = "AV.GetUserDemographics";

		/// <summary>
		/// Default parameterless constructor: get user demographics security 
		/// request message does not require any parameters to be created. 
		/// </summary>
		public SecurityGetUserDemographicsRequestMessage() 
			: base( RequestType ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecurityGetUserDemographicsRequestMessage( XmlDocument sourceDoc ) 
			: base( RequestType, sourceDoc ) {}
	}
}
